// utf_editDlg.cpp : implementation file
//

#include "stdafx.h"
#include "utf_edit.h"
#include "utf_editDlg.h"
#include "UTF.h"
#include "SDD.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

UTF * utf = NULL;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About


class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUtf_editDlg dialog

CUtf_editDlg::CUtf_editDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUtf_editDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUtf_editDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUtf_editDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUtf_editDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUtf_editDlg, CDialog)
	//{{AFX_MSG_MAP(CUtf_editDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE, OnSelchangedTree)
	ON_NOTIFY(NM_CLICK, IDC_TREE, OnClickTree)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_NOTIFY(TVN_ENDLABELEDIT, IDC_TREE, OnEndlabeleditTree)
	ON_BN_CLICKED(IDC_IMPORTDATA, OnImportdata)
	ON_BN_CLICKED(IDC_EXPORTDATA, OnExportdata)
	ON_BN_CLICKED(IDC_DELETELEAF, OnDeleteleaf)
	ON_BN_CLICKED(IDC_NEWUTF, OnNewutf)
	ON_BN_CLICKED(IDC_ADDNODE, OnAddnode)
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUtf_editDlg message handlers

BOOL CUtf_editDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	CListBox * type = (CListBox *) GetDlgItem(IDC_LISTDATATYPE);
	type->AddString("string");
	type->AddString("int array");
	type->AddString("float array");
	type->SelectString(-1,"float array");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUtf_editDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUtf_editDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUtf_editDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


char * CUtf_editDlg::FileDialog(int type)
{
	CFileDialog fd(type == FILE_DIALOG_LOAD);
	fd.DoModal();
	strcpy(utf_fileName, fd.GetFileName().GetBuffer(1999));

	return utf_fileName;
}

void CUtf_editDlg::OnSelchangedTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	CEdit * ascii = (CEdit *) GetDlgItem(IDC_ASCII);
	CEdit * hex = (CEdit *) GetDlgItem(IDC_HEX);
	CEdit * size = (CEdit *) GetDlgItem(IDC_CHUNKSIZE);

	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);
	HTREEITEM item = tree->GetSelectedItem();
	
	char * data = (char *)tree->GetItemData(item);

	#define HEX_SIZE 10

	if (data)
	{
		ascii->SetWindowText(data + 4);

		int it = min (HEX_SIZE, *(int *)data);
		char text[HEX_SIZE*3];	// * 3 -> 2 digits + 1 space
		memset (text, 0, HEX_SIZE * 3);

		for (int i = 0; i < it; i ++)
			sprintf (text + 3*i, "%02X ",(unsigned char)*(data+4+i));
		hex->SetWindowText(text);

		sprintf (text, "%d", *(int *)data);
		size->SetWindowText(text);

	}
	else
	{
		ascii->SetWindowText("");
		hex->SetWindowText("");
		size->SetWindowText("");
	}

	
	*pResult = 0;
}

void CUtf_editDlg::OnClickTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}


// Open UTF 
void CUtf_editDlg::OnOK() 
{
	char * fileName = FileDialog(FILE_DIALOG_LOAD);
	if ( fileName[0] == 0) return;

	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);

	if (utf)
	{
		utf->DestroyTree(tree);
		delete utf;
	}
	utf = new UTF ( fileName, tree );
}

void CUtf_editDlg::OnSave() 
{
	char * fileName = FileDialog(FILE_DIALOG_SAVE);
	if ( fileName[0] == 0) return;
	
	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);
	utf->Save(tree, fileName);
}

void CUtf_editDlg::OnEndlabeleditTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_DISPINFO* pTVDispInfo = (TV_DISPINFO*)pNMHDR;
	
	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);
	if((CString)pTVDispInfo->item.pszText!="") //only if not blank
	{
		HTREEITEM hItem=pTVDispInfo->item.hItem;
		tree->SetItemText(pTVDispInfo->item.hItem, pTVDispInfo->item.pszText);
	}
	
	*pResult = 0;
}

void CUtf_editDlg::OnImportdata() 
{
	char * data;
	int file_size;

	if (utf == NULL) return;

	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);
	HTREEITEM selected = tree->GetSelectedItem();

	// check if we're on a leaf, if not bail out
	if ( tree->GetChildItem(selected) != 0)
	{
		MessageBox("Cannot import data to non-leaf nodes", "Error", MB_ICONERROR);
		return;
	}

	data = (char *) tree->GetItemData(selected);

	char * fileName = FileDialog(FILE_DIALOG_LOAD);

	if ( fileName[0] == 0) return;

	FILE * f = fopen (fileName, "rb");
	if (f)
	{
		// if data exists on this leaf, free it
		if (data)	free (data);

		// import file
		fseek(f, 0, SEEK_END);
		file_size = ftell(f);
		fseek(f, 0, SEEK_SET);

		data = (char *) malloc (file_size + 4);
		fread (data + 4, file_size, 1, f);
		*(int *)data = file_size;

		tree->SetItemData(selected, (DWORD)data);

		fclose(f);
	}
}

void CUtf_editDlg::OnExportdata() 
{
	char * data;
	int file_size;

	if (utf == NULL) return;

	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);
	HTREEITEM selected = tree->GetSelectedItem();

	// check if we're on a leaf, if not bail out
	if ( tree->GetChildItem(selected) != 0)
	{
		MessageBox("Cannot export data from non-leaf nodes (no data present)", "Error", MB_ICONERROR);
		return;
	}

	data = (char *) tree->GetItemData(selected);


	char * fileName = FileDialog(FILE_DIALOG_SAVE);

	if ( fileName[0] == 0) return;

	FILE * f = fopen (fileName, "wb");
	if (f)
	{
		file_size = *(int *)data;
		fwrite (data + 4, file_size, 1, f);
		fclose(f);
	}
}

void CUtf_editDlg::OnDeleteleaf() 
{
	if (utf == NULL) return;

	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);
	HTREEITEM selected = tree->GetSelectedItem();

	if (selected == NULL) return;

	utf->RemoveNode(tree, selected, false);
}

void CUtf_editDlg::OnNewutf() 
{
	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);

	if (utf)
	{
		utf->DestroyTree(tree);
		delete utf;
	}
	utf = new UTF ();

	utf->AddNewNode(tree, NULL, "\\");
}

void CUtf_editDlg::OnAddnode() 
{
	if (utf == NULL) return;

	CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);
	HTREEITEM selected = tree->GetSelectedItem();
	utf->AddNewNode(tree, selected, "New node");	
}

void CUtf_editDlg::OnEdit() 
{
	if (utf)
	{
		CTreeCtrl * tree = (CTreeCtrl *) GetDlgItem(IDC_TREE);
		HTREEITEM selected = tree->GetSelectedItem();

		if (selected == NULL)
			MessageBox("Select a leaf node to edit.", "Error", MB_ICONERROR);
		else if (tree->GetChildItem(selected) != NULL)
			MessageBox("Not a leaf node, no data to edit.", "Error", MB_ICONERROR);
		else
		{
			CListBox * box = (CListBox *) GetDlgItem(IDC_LISTDATATYPE);
			SDD sdd;
			sdd.SetType(box->GetCurSel());
			sdd.SetTreeItem(tree, selected);
			sdd.DoModal();
		}
	}
}
